"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isCorrect = exports.isInSubnet = void 0;
function isInSubnet(address) {
    if (this.subnetMask < address.subnetMask) {
        return false;
    }
    if (this.mask(address.subnetMask) === address.mask()) {
        return true;
    }
    return false;
}
exports.isInSubnet = isInSubnet;
function isCorrect(defaultBits) {
    return function () {
        if (this.addressMinusSuffix !== this.correctForm()) {
            return false;
        }
        if (this.subnetMask === defaultBits && !this.parsedSubnet) {
            return true;
        }
        return this.parsedSubnet === String(this.subnetMask);
    };
}
exports.isCorrect = isCorrect;//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/c89e16d62ef8bc282bd272360e7a80562ac104a1-5345a682642cf58747f762929f3836a2b034c868/node_modules/ip-address/dist/common.js.map